package hunter;

import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.introspection.PogProp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.*;

/**
 * PLAYGROUND for the platform testers :-)
 *
 * This bot contains a lot of code and isn't that stupid at all! This is the Hunter.
 * It collects weapons in map, runs for medkits when it's health is low, trying to kill anybody
 * from different team on sight. Well it's not clever as it doesn't trying to follow it's
 * prey around the corner. And that is where you can step in and start to play with our platform!
 * <p>
 * derived from AdvancedBot
 * <p>
 * Plan / if-then rules organization:
 * <ol>
 * <li> do you see enemy and possess better weapon? 
 *							 -> go to CHANGE_WEAPON	(change to better weapon)	
 * <li> do you see enemy?    -> go to ENGAGE		(start shooting / hunt the enemy / change weapon)
 * <li> are you shooting?    -> go to STOP_SHOOTING	(stop shooting, you've lost your target) 
 * <li> are you being shot?  -> go to HIT			(turn around - try to find your enemy)   
 * <li> are you walking? 	   -> go to WALKING		(check WAL)
 * <li> are you following enemy? -> go to PURSUE	(run to enemy last position)
 * <li> do you see item?	   -> go to GRAB_ITEM	(pick the most suitable item and run for it)	
 * <li> are you hurt?		 -> go to MED_KITS		(run around list of Health items - MedKits, HealthVials)
 * <li> have nothing to do?	   
 * 						   -> go to RUN_AROUND_ITEMS (randomize array of known items and run around 
 * 													  those items using GET_PATH)	
 * </ol>
 * Each state you see here can be found in method - stateXXX.
 * <p>
 * It doesn't look hard, but it's not so simple - check out respective methods
 * for those states and then think about how you could improve this Hunter.
 * <p>
 * Hunter is also counting it's deaths and frag for itself.
 * 
 * @author Ondra
 */
public class Main extends Agent {
	
	/** choosen item for the state seeItem */
	protected Item choosenItem = null;
	/** choose med kits for the stateMedKit */
	protected ArrayList <Item> choosenMedKits = null;
	/** is used to store shuffled list of weapons bot runs around */
	private ArrayList<Item> itemsToRunAround = null;	
	/** last enemy which disappeared from agent's view */
	private Player lastEnemy = null;
	/** the enemy we're fixed at. If null no enemy is engaged. */
	private Player enemy = null;        
	/** max attempts in reaching the item */
	protected final int MAX_ATTEMPTS = 10;
	/** 
	  * Stores last unreachable item - item that bot chose and was not able to go to. <br>
	  * This setting should prevent bot from stucks.
	  */
	protected Item previousChoosenItem = null;
	/** counter for attempts in reaching the item */ 
	protected int walkingAttempts = 0;

	/** walking mystic properties - prevent bot from continuous jumping - he will jump only once */
	private boolean jumped;
		
	/** use built-in A* algorithm or not use built-in A* algorithm? that is a question */
	@PogProp public boolean useAStar = false;
	/*******
	 * AGENT SWITCHES!!!
	 *******/
	/** boolean switch to activate engage */
	@PogProp public boolean shouldEngage = true;
	/** boolean switch to activate pursue */
	@PogProp public boolean shouldPursue = true;
	/** boolean switch to activate rearm */
	@PogProp public boolean shouldRearm = true;
	/** boolean switch to activate collect items */
	@PogProp public boolean shouldCollectItems = true;
	/** boolean switch to activate collect health */
	@PogProp public boolean shouldCollectHealth = true;
	/** how low the health level should be to start collecting healht */
	@PogProp public int healthLevel = 90;
    
    /** how many bot the hunter killed */    
    @PogProp public int frags = 0;
    /** how many times the hunter died */
    @PogProp public int deaths = 0;
    
        private WALFALListener listener = new WALFALListener();
        
        private class WALFALListener implements RcvMsgListener {
            
            public WALFALListener() {
                body.addTypedRcvMsgListener(this, MessageType.WALL_COLLISION);
                body.addTypedRcvMsgListener(this, MessageType.FALL);
            }

            public void receiveMessage(RcvMsgEvent e) {
                body.jump();
            }
            
        }

	public Main() {
		super();
		this.log.setLevel(Level.INFO);
		this.platformLog.setLevel(Level.INFO);
	}               
	
        @Override
        protected void prePrepareAgent() {
            this.body.initializer.setTeam(1);
        }
        
	/**
	 * Prepares list of agent will run around. <br>
	 * He will run only around weapons and armors so he will be armored and armed soon
	 */
        @Override
	protected void postPrepareAgent() {
		this.itemsToRunAround = new ArrayList<Item>();
		 for ( Item item : this.memory.getKnownWeapons())
		 	this.itemsToRunAround.add(item);
		 for ( Item item : this.memory.getKnownArmors())
		 	this.itemsToRunAround.add(item);
		 Collections.shuffle(itemsToRunAround);
                 this.body.initializer.setBotSkillLevel(3);
	}

	/**
	 * Main method of the bot's brain - we're going to do some thinking about
	 * the situation we're in (how it's unfair to be the bot in the gloomy world
	 * of UT2004 :-).
	 * <p>
	 * Check out the javadoc for this class - there you find a basic concept
	 * of this bot.
	 */
        @Override
	protected void doLogic() {
		// IF-THEN RULES:
		// 1) see enemy and has better weapon? -> switch to better weapon
		if (this.shouldRearm && this.memory.getSeeAnyEnemy() && this.hasBetterWeapon()) { this.stateChangeToBetterWeapon(); return; }

		// 2) do you see enemy? 	-> go to PURSUE (start shooting / hunt the enemy)		
		if (this.shouldEngage && this.memory.getSeeAnyEnemy() && this.memory.hasAnyLoadedWeapon()) { this.stateEngage(); return; }
		
		// 3) are you shooting? 	-> go to STOP_SHOOTING (stop shooting, you've lost your target)
		if (this.memory.isShooting()) { this.stateStopShooting(); return; }

		// 4) are you being shot? 	-> go to HIT (turn around - try to find your enemy)
		if (this.memory.isBeingDamaged()) { this.stateHit(); return; }
		
		// 5) have you got enemy to pursue? -> go to the last position of enemy 
                if ((this.lastEnemy != null) && (this.shouldPursue) && (this.memory.hasAnyLoadedWeapon())) { this.stateGoAtLastEnemyPosition(); return; }
		// 6) are you walking? 	   	-> go to WALKING       (check WAL)
		//if (this.memory.isColliding()) { this.stateWalking(); return; }
		
		// 7) do you see item? 		-> go to GRAB_ITEM	  (pick the most suitable item and run for)	
		if (this.shouldCollectItems && this.seeAnyReachableItemAndWantIt()) { this.stateSeeItem(); return; }

		// 8) are you hurt?			-> get yourself some medKit
		if (this.memory.getAgentHealth() < this.healthLevel && this.canRunAlongMedKit()) { this.stateMedKit(); return; }
		
		// 9) run around items		
		this.stateRunAroundItems(); 	return;
	}
	
	/**
	 * changes to better weapon that he posseses
	 */
	protected void stateChangeToBetterWeapon() {
		this.log.log(Level.INFO, "Decision is: CHANGE WEAPON");
        if (memory.getAgentLocation() == null || memory.getSeeEnemy() == null || memory.getSeeEnemy().location == null)
            return;
		AddWeapon weapon = memory.getBetterWeapon(memory.getAgentLocation(), memory.getSeeEnemy().location);
		if (weapon != null)
			body.changeWeapon(weapon);
	}
	/**
	 * has better weapon - this magic check goes through weapons in inventory and according to their characteristics
	 * decides which is the best - that means which effectiveDistance is lowest and which maximal distance is big enough
	 * to reach enemy.
	 * </p>
	 * <p>
	 * Note!: Both effective and maximal distance are guessed and therefore could not work exactly
	 * </p>
	 */
	protected boolean hasBetterWeapon() {
                if (memory.getAgentLocation() == null || memory.getSeeEnemy() == null || memory.getSeeEnemy().location == null)
                    return false;
		AddWeapon weapon = memory.getBetterWeapon(memory.getAgentLocation(), memory.getSeeEnemy().location);
                // platformLog.info("Better weapon : " + weapon + "\nWeapons: " + this.memory.getAllWeapons().toString());                        
		if (weapon == null)
			return false;
		else
			return true;	
	}		


	/**
	 * Fired when bot see any enemy.
	 * <ol>
	 * <li> if have enemyID - checks whether the same enemy is visible, if not, drop him (and stop shooting)
	 * <li> if doesn't have enemyID - pick one of the enemy for pursuing
	 * <li> if not shooting at enemyID - start shooting
	 * <li> if out of ammo - switch to another weapon
	 * <li> if enemy is reachable - run to him
	 * <li> if enemy is not reachable - stand still (kind a silly, right? :-)
	 * </ol>
	 */
	protected void stateEngage() {
		this.log.log(Level.INFO, "Decision is: ENGAGE");
		// 1) if have enemyID - checks whether the same enemy is visible, if not, drop ID (and stop shooting)
		if (this.enemy != null){
                        this.lastEnemy = enemy;
                        this.enemy = this.memory.getSeePlayer(this.enemy.ID); // refresh information about the enemy,
                        // note that even though we've got pointer to the message of the enemy seen, it's still a certain message 
                        // from a specific time - when new message arrives it's written as a new message
			if (this.enemy == null){			
                            if (this.memory.isShooting())
                                this.body.stopShoot(); // stop shooting, we've lost target
                            return;
			}
		}
		
		// 2) if doesn't have enemy - pick one of the enemy for pursuing
		if (this.enemy == null){
			this.enemy = this.memory.getSeeEnemy();
			if (this.enemy == null){
				this.body.stop();
				this.body.stopShoot();
				return;				
			}
		}
		
		AddWeapon weapon = null;
		// 3) if out of ammo - switch to another weapon
		if ((!this.memory.hasLoadedWeapon()) && this.memory.hasAnyLoadedWeapon()) {
                        platformLog.info("no ammo - switching weapon " + this.memory.hasLoadedWeapon() + " " 
                                + this.memory.getAnyWeapon() + "\nCurrent Weapon:" + this.memory.getCurrentWeapon()
                                + "\nWeapons : " + this.memory.getAllWeapons().toString());
			weapon = this.memory.getAnyWeapon();
                        if ((weapon != null) && ((memory.getCurrentWeapon() == null) || ((memory.getCurrentWeapon() != null) 
                            && (!weapon.weaponType.equals(memory.getCurrentWeapon().weaponType))))) {
                            platformLog.info("no ammo - switching weapon: " + weapon);
                            this.body.changeWeapon(weapon);
                        } else {
                            
                        }
		}
		
		// 4) if not shooting at enemyID - start shooting
		double distance = (Triple.distanceInSpace(this.memory.getAgentLocation(), this.enemy.location));
		if (this.memory.getCurrentWeapon() != null && this.memory.getCurrentWeapon().maxDist > distance) {// it is worth shooting
                    platformLog.info("Would like to shoot at enemy!!!");
                    if (!this.memory.isShooting())
                        this.body.shoot(this.enemy);
                    else // to turn to enemy - shoot will not turn to enemy during shooting
                        this.body.turnToTarget(this.enemy);
                }
		
		// 5) if enemy is far - run to him
		int decentDistance = Math.round(this.random.nextFloat() * 800) + 200;
		
		if (this.memory.getAgentLocation() != null && this.enemy != null && this.enemy.location != null &&
			Triple.distanceInSpace(this.memory.getAgentLocation(), this.enemy.location) < decentDistance){
			if (this.memory.isMoving()){
				this.body.stop();
			}
		} else {
			this.body.runToTarget(enemy);
			this.jumped = false;
		}
	}
	
	/**
	 * Fired when bot loose enemy from his view <br>
	 * He just stops shooting and no more wastes his ammo
	 */
	protected void stateStopShooting() {
		this.log.log(Level.INFO, "Decision is: STOP_SHOOTING");
		this.body.stopShoot();
	}
	
	/**
	 * Fired when bot is damaged, it has those options:
	 * <ol>
	 * <li> He has idea where to turn to from to DAM message
	 * <li> He got no idea at all -> turns around
	 * </ol>
	 */
	protected void stateHit() {
		this.log.log(Level.INFO, "Decision is: HIT");
		this.body.turnHorizontal(55);
	}

	/**
	 * Fired when bot is moving, checks few accidents than can happen to him
	 * <ol>
	 * <li> Wall collision
	 * <li> Fell of the bot
	 * <li> Bump to another actor of the game
	 * </ol>
	 */
	protected void stateWalking() {
		this.log.log(Level.INFO, "Decision is: WALKING");
		
		if (this.memory.isColliding())
			if (!this.jumped){
				this.body.doubleJump();
				this.jumped = true;
			} else {
				this.body.stop();
				this.jumped = false;
			}
		if (this.memory.isFalling()){
			this.body.sendGlobalMessage("I am flying like a bird:D!");
			this.log.info("I'm flying like an angel to the sky ... it's so high ...");
		}
		if (this.memory.isBumpingToAnotherActor()){
			this.body.stop();
		}
	}
	/**
	 * State pursue is for pursuing enemy who was for example lost behind a corner.
	 * How it works?:
	 * <ol>
	 * <li> initialize properties 
	 * <li> obtain path to the enemy
	 * <li> follow the path - if it reaches the end - set lastEnemy to null - bot would have seen him before or lost him once for all
	 * </ol>
	 */
	protected void stateGoAtLastEnemyPosition() {
		this.log.log(Level.INFO, "Decision is: PURSUE");
                if(!this.gameMap.safeRunToLocation(lastEnemy.location)) {         // unable to reach the choosen item
                        log.info("Ended at the enemy possition or failed - > STOP THE CHASE.");
                        previousChoosenItem = choosenItem;
                        lastEnemy = null;
                }
                if (lastEnemy != null && atLocation(lastEnemy.location)) {
                    log.info("Ended at the enemy possition or failed - > STOP THE CHASE.");
                    previousChoosenItem = choosenItem;
                    lastEnemy = null;
                }
		return;
	}

	/**
	 * checks whether there are any medkit items around and if there are
	 * checks if the agent is not standing on the first one in the choosenMedKits
	 * <p>
	 * (bot got stucked because nearestHealth returns Healths according to inventory spots
	 * not to the current situation, so the bot with low health got stucked on the inventory spot)
	 * <p>
	 * @return true if bot can run along med kits - initialize them before that
	 */
	protected boolean canRunAlongMedKit() {
		if (this.choosenMedKits == null) {
			this.choosenMedKits = this.gameMap.nearestHealth(4, 8);
		}
		// no medkits to run to around the agent - restricted AStar - see nearestHealth
		if (choosenMedKits.isEmpty()) {
			this.choosenMedKits = null;
			return false;
		}
		// bot is too close to the object - possibly standing at the only one
		if (Triple.distanceInSpace(choosenMedKits.get(0).location, memory.getAgentLocation()) < 15) {
			// there are many - remove the first one - seeItem has highest priority, so bot should
			// pick up the item anyway and otherwise will not get stucked at the inventory spot of 
			// the item
			if (choosenMedKits.size() > 2)
				choosenMedKits.remove(0);
			else {
				this.choosenItem = null;
				return false;
			}
		}
		return true;
	} 
	
	/**
	 * runs along healths of strenght at least 8 to recover health
	 */
	protected void stateMedKit() {
		this.log.log(Level.INFO, "Decision is: RUN_MED_KITS");
		this.gameMap.runAroundItemsInTheMap(choosenMedKits, this.useAStar);
	}
	
	/** 
	 * choose weapon according to the one he is currently holding
	 * <ol>
	 * <li> has melee and see ranged => pick up ranged
	 * <li> has ranged and see melee => pick up melee
	 * <li> pick up first weapon he sees
	 * </ol>
	 * 
	 * @return the choosen one weapon
	 */
	private Weapon chooseWeapon() {
		ArrayList<Weapon> weapons = memory.getSeeReachableWeapons();			
		for (Weapon weapon:weapons) {
			// 0) has no weapon in hands
			if (this.memory.getCurrentWeapon() == null)
				return weapon;
			// 1) weapon is ranged, bot has melee
			if ((this.memory.getCurrentWeapon().melee) && !weapon.isMelee() && !this.memory.hasWeaponOfType(weapon.weaponType)){
				return weapon;
			}
			// 2) weapon is melee, bot has ranged
			if (!this.memory.getCurrentWeapon().melee && weapon.isMelee() && !this.memory.hasWeaponOfType(weapon.weaponType)){
				return weapon;
			}
		}
		Weapon chosen = this.memory.getSeeReachableWeapon();
		if (!this.memory.hasWeaponOfType(chosen.weaponType)){
			return chosen;
		}
		return null;
	}
	
	/**
	 * Reasoning about what to do with seen item <br>
	 * the easiest way of handeling it will be just to take it every time, but what should we do
	 * when there are many of items laying in front of agent?
	 * <ol>
	 * <li> choose weapon - choose the type he is lacking (melee/ranged)
	 * <li> choose armor
	 * <li> choose health - if the health is bellow normal maximum
	 * <li> choose ammo - if it is suitable for possessed weapons
	 * <li> ignore the item
	 * </ol>
	 */
	private Item chooseItem() {
		// 1) choose weapon - choose the type he is lacking (melee/ranged)
		if (this.memory.getSeeAnyReachableWeapon())
			return chooseWeapon();
		// 2) choose armor
		if (this.memory.getSeeAnyReachableArmor())
			return this.memory.getSeeReachableArmor();
		// 3) choose health - if the health is bellow normal maximum or the item is boostable
		if (this.memory.getSeeAnyReachableHealth()) {
			Health health = this.memory.getSeeReachableHealth();
			if (this.memory.getAgentHealth() < 100)
				return health;
			if (health.boostable) // if the health item is boostable, grab it anyway:)
				return health;
		}	
		// 4) choose ammo - if it is suitable for possessed weapons
		if ((this.memory.getSeeAnyReachableAmmo()) && 
			(this.memory.isAmmoSuitable(this.memory.getSeeReachableAmmo())))
			return this.memory.getSeeReachableAmmo();
		// 5) ignore the item
		return null;
	}

	/** 
	 * sees reachable item and wants it
	 * @return true if there is an item which is useful for agent
	 */
	private boolean seeAnyReachableItemAndWantIt() {
		if (this.memory.getSeeAnyReachableItem()){
			choosenItem = chooseItem();
			if (choosenItem != null) {
				this.log.info("NEW ITEM CHOSEN: " + choosenItem);
				this.log.info("LAST CHOOSEN ITEM: " + previousChoosenItem);
                        }
		} else {
			choosenItem = null;
		}
		if ((choosenItem != null) && (!choosenItem.equals(previousChoosenItem)))
                    //&& (Triple.distanceInSpace(memory.getAgentLocation(), choosenItem.location) > 20))
                    return true;
                else
                    return false;
	}
    
        
	/**
	 * run along the path to choosen item
	 */
	protected void stateSeeItem() {
		this.log.log(Level.INFO, "Decision is: SEE_ITEM --- Running for: " + this.choosenItem.toString());		                
                
                if((choosenItem != null && atLocation(choosenItem.location)) || 
                   !this.gameMap.safeRunToLocation(choosenItem.location)) {         // unable to reach the choosen item
                        log.info("unable to REACH the choosen item");
                        previousChoosenItem = choosenItem;
                        choosenItem = null;
                }
                this.jumped = false;
	}	
        
        private boolean atLocation(Triple triple) {
            return Triple.distanceInSpace(triple, memory.getAgentLocation()) < 80;
        }
	
	/**
	 * call predefined function in GameMap - runAroundWeaponsInTheMap
	 */
	protected void stateRunAroundItems() {
		this.log.log(Level.INFO, "Decision is: RUN_AROUND_ITEMS");
		this.gameMap.runAroundItemsInTheMap(itemsToRunAround, useAStar);
	}

    /**
     * This is method from interface RcvMsgListener, every message that goes from GB2004 to Agent goes 
     * also through here.
     * We're using it to count the frags and deaths of the hunter.
     */ 	
        @Override
	public void receiveMessage(RcvMsgEvent e) {
		// DO NOT DELETE! Otherwise things will screw up! Agent class itself is also using this listener...
        super.receiveMessage(e);
        
        // Take care of frags and deaths.
        switch(e.getMessage().type) {
            case PLAYER_KILLED:
                frags += 1;
                break;
            case BOT_KILLED:
                deaths += 1;
                break;
        }
    }

/**
 * NOTE: this method MUST REMAIN DEFINED + MUST REMAIN EMPTY, due to technical reasons.
 */		
	public static void main (String[] Args) {
	}

}
